/*
** Create the window, grow a box for effect, and open the window.
** Arrange for horizontal and vertical sliders
** to exist, and set them to initial values passed to us.
*/

# include <gemdefs.h>
# include <osbind.h>
# include <wfparts.h>

open_window(name,vertical,horizontal,vsize,hsize,dx,dy,dw,dh)
char *name;
int vertical, horizontal, vsize, hsize, dx, dy, dw, dh;{
	
	int wi_handle, fx, fy, fw, fh;
	
	wind_get(0, WF_WORKXYWH, &fx, &fy, &fw, &fh );
	wi_handle = wind_create<WF_PARTS,fx,fy,fw,fh);
	wind_set(wi_handle, WF_NAME,name,0,0);
	wind_set(wi_handle, WF_VSLSIZE,vsize,0,0);
	wind_set(wi_handle, WF_HSLSIZE,hsize,0,0);
	wind_set(wi_handle, WF_VSLIDE,1000-vertical,0,0,0,0);
	wind_set(wi_handle, WF_HSLIDE,horizontal,0,0);
	graf_growbox( dx + dw/2, dy + dh/2, 2, 2, dx, dy, dw, dh );
	wind_open(wi_handle,dx,dy,dw,dh);
	return( wi_handle );
}
